/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.performance.EstimatedPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.WekaTools;
import java.util.BitSet;
import weka.attributeSelection.ConsistencySubsetEval;
import weka.core.Instances;

public class ConsistencyFeatureSetEvaluator
extends Operator {
    public ConsistencyFeatureSetEvaluator(OperatorDescription description) {
        super(description);
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "TempInstances", 0);
        double performance = 0.0;
        try {
            ConsistencySubsetEval evaluator = new ConsistencySubsetEval();
            evaluator.buildEvaluator(instances);
            BitSet bitSet = new BitSet(exampleSet.getAttributes().size());
            bitSet.flip(0, exampleSet.getAttributes().size());
            performance = evaluator.evaluateSubset(bitSet);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, new Object[]{"ConsistencySubsetEval", e.getMessage()});
        }
        PerformanceVector result = new PerformanceVector();
        result.addCriterion(new EstimatedPerformance("ConsistencyFS", performance, 1, false));
        return new IOObject[]{result};
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }
}

