/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MappedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.Tools;
import edu.udo.cs.yale.operator.validation.ValidationChain;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBootstrappingValidation
extends ValidationChain {
    private int number;
    private int iteration;

    public AbstractBootstrappingValidation(OperatorDescription description) {
        super(description);
        this.addValue(new Value("iteration", "The number of the current iteration."){

            public double getValue() {
                return AbstractBootstrappingValidation.this.iteration;
            }
        });
    }

    protected abstract int[] createMapping(ExampleSet var1, int var2, Random var3) throws OperatorException;

    @Override
    public IOObject[] estimatePerformance(ExampleSet inputSet) throws OperatorException {
        this.number = this.getParameterAsInt("number_of_validations");
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        ArrayList<AverageVector> averageVectors = new ArrayList<AverageVector>();
        this.iteration = 0;
        while (this.iteration < this.number) {
            int[] mapping = this.createMapping(inputSet, (int)Math.round((double)inputSet.size() * this.getParameterAsDouble("sample_ratio")), random);
            MappedExampleSet trainingSet = new MappedExampleSet((ExampleSet)inputSet.clone(), mapping, true);
            this.learn(trainingSet);
            MappedExampleSet inverseExampleSet = new MappedExampleSet((ExampleSet)inputSet.clone(), mapping, false);
            IOContainer evalOutput = this.evaluate(inverseExampleSet);
            Tools.handleAverages(evalOutput, averageVectors, this.getParameterAsBoolean("average_performances_only"));
            this.inApplyLoop();
            ++this.iteration;
        }
        PerformanceVector averagePerformance = Tools.getPerformanceVector(averageVectors);
        if (averagePerformance != null) {
            this.setResult(averagePerformance.getMainCriterion());
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_of_validations", "Number of subsets for the crossvalidation.", 2, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("sample_ratio", "This ratio of examples will be sampled (with replacement) in each iteration.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean("average_performances_only", "Indicates if only performance vectors should be averaged or all types of averagable result vectors.", true));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

