/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.sampling;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SimpleExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSampling
extends Operator {
    private double fraction = 0.1;

    public SimpleSampling(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        this.fraction = this.getParameterAsDouble("sample_ratio");
        LinkedList<DataRow> dataList = new LinkedList<DataRow>();
        for (Example example : exampleSet) {
            if (this.accept(example)) {
                dataList.add(example.getDataRow());
            }
            this.checkForStop();
        }
        List<Attribute> attributes = Arrays.asList(exampleSet.getExampleTable().getAttributes());
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes, new ListDataRowReader(dataList.iterator()));
        LinkedList<Attribute> regularAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            regularAttributes.add(attribute);
        }
        SimpleExampleSet result = new SimpleExampleSet((ExampleTable)exampleTable, regularAttributes);
        Iterator<AttributeRole> special = exampleSet.getAttributes().specialAttributes();
        while (special.hasNext()) {
            AttributeRole role = special.next();
            result.getAttributes().setSpecialAttribute(role.getAttribute(), role.getSpecialName());
        }
        return new IOObject[]{result};
    }

    protected boolean accept(Example example) throws UndefinedParameterError {
        return RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed")).nextDouble() < this.fraction;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("sample_ratio", "The fraction of examples which should be sampled", 0.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

