/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.sampling;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.example.SimpleExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.meta.WeightedPerformanceMeasures;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBasedSampling
extends Operator {
    public ModelBasedSampling(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute weightAttr = exampleSet.getAttributes().getWeight();
        if (weightAttr == null) {
            weightAttr = Tools.createWeightAttribute(exampleSet);
            Iterator reader = exampleSet.iterator();
            while (reader.hasNext()) {
                ((Example)reader.next()).setValue(weightAttr, 1.0);
            }
        }
        WeightedPerformanceMeasures wp = new WeightedPerformanceMeasures(exampleSet);
        WeightedPerformanceMeasures.reweightExamples(exampleSet, wp.getContingencyMatrix(), true);
        exampleSet.recalculateAttributeStatistics(exampleSet.getAttributes().getWeight());
        Attribute[] allAttributes = exampleSet.getExampleTable().getAttributes();
        LinkedList<DoubleArrayDataRow> dataList = new LinkedList<DoubleArrayDataRow>();
        Iterator reader = exampleSet.iterator();
        double maxWeight = ((NumericalAttributeStatistics)exampleSet.getAttributes().getWeight().getStatistics()).getMaximum();
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            if (RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed")).nextDouble() > example.getValue(weightAttr) / maxWeight) {
                example.setValue(weightAttr, 1.0);
                double[] values = new double[allAttributes.length];
                int i = 0;
                while (i < values.length) {
                    values[i] = example.getValue(allAttributes[i]);
                    ++i;
                }
                dataList.add(new DoubleArrayDataRow(values));
            }
            this.checkForStop();
        }
        List<Attribute> attributes = Arrays.asList(allAttributes);
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes, new ListDataRowReader(dataList.iterator()));
        LinkedList<Attribute> regularAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            regularAttributes.add(attribute);
        }
        SimpleExampleSet result = new SimpleExampleSet((ExampleTable)exampleTable, regularAttributes);
        Iterator<AttributeRole> special = exampleSet.getAttributes().specialAttributes();
        while (special.hasNext()) {
            AttributeRole role = special.next();
            result.getAttributes().setSpecialAttribute(role.getAttribute(), role.getSpecialName());
        }
        return new IOObject[]{result};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

