/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.sampling;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MappedExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBootstrapping
extends Operator {
    public AbstractBootstrapping(OperatorDescription description) {
        super(description);
    }

    public abstract int[] createMapping(ExampleSet var1, int var2, Random var3) throws OperatorException;

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        int[] mapping = this.createMapping(exampleSet, (int)Math.round((double)exampleSet.size() * this.getParameterAsDouble("sample_ratio")), random);
        MappedExampleSet bootstrappedExampleSet = new MappedExampleSet(exampleSet, mapping, true);
        return new IOObject[]{bootstrappedExampleSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("sample_ratio", "This ratio determines the size of the new example set.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeInt("local_random_seed", "Local random seed for this operator (-1: use global random seed).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

