/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.outlier;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.preprocessing.outlier.SearchObject;
import edu.udo.cs.yale.operator.preprocessing.outlier.SearchSpace;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOFOutlierOperator
extends Operator {
    private static final String[] distanceFunctionList = new String[]{"euclidian distance", "squared distance", "cosine distance", "inverted cosine distance", "angle"};

    public LOFOutlierOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int minPtsLowerBound = 0;
        int minPtsUpperBound = 0;
        int minPtsLB = this.getParameterAsInt("minimal_points_lower_bound");
        int minPtsUB = this.getParameterAsInt("minimal_points_upper_bound");
        int kindOfDistance = this.getParameterAsInt("distance_function");
        if (minPtsLB <= minPtsUB) {
            minPtsLowerBound = minPtsLB;
            minPtsUpperBound = minPtsUB;
        } else {
            minPtsLowerBound = minPtsUB;
            minPtsUpperBound = minPtsLB;
        }
        ExampleSet eSet = this.getInput(ExampleSet.class);
        Iterator reader = eSet.iterator();
        int searchSpaceDimension = eSet.getAttributes().size();
        SearchSpace sr = new SearchSpace(searchSpaceDimension, minPtsLowerBound, minPtsUpperBound + 1);
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            SearchObject so = new SearchObject(searchSpaceDimension, "object" + counter, minPtsLowerBound, minPtsUpperBound);
            ++counter;
            int i = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                so.setVektor(i++, example.getValue(attribute));
            }
            sr.addObject(so);
        }
        LogService.logMessage(String.valueOf(this.getName()) + ": Searching d=" + sr.getDimensions() + " dimensions with" + " MinPts Interval [" + minPtsLowerBound + " ; " + minPtsUpperBound + "]", 2);
        sr.resetOutlierStatus();
        sr.findAllKdContainers(kindOfDistance);
        sr.computeLOF(minPtsLowerBound, minPtsUpperBound);
        Attribute outlierAttribute = AttributeFactory.createAttribute("Outlier", 4);
        eSet.getExampleTable().addAttribute(outlierAttribute);
        eSet.getAttributes().setOutlier(outlierAttribute);
        counter = 0;
        for (Example example : eSet) {
            SearchObject sobj = sr.getSearchObjects().elementAt(counter);
            example.setValue(outlierAttribute, sobj.getOutlierFactor());
            ++counter;
        }
        return new IOObject[]{eSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("minimal_points_lower_bound", "The lower bound for MinPts for the Outlier test (default value is 10)", 0, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeInt("minimal_points_upper_bound", "The upper bound for MinPts for the Outlier test (default value is 20)", 0, Integer.MAX_VALUE, 20));
        types.add(new ParameterTypeCategory("distance_function", "choose which distance function will be used for calculating the distance between two objects", distanceFunctionList, 0));
        return types;
    }
}

