/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.outlier;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.preprocessing.outlier.SearchObject;
import edu.udo.cs.yale.operator.preprocessing.outlier.SearchSpace;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DKNOutlierOperator
extends Operator {
    private static final String[] distanceFunctionList = new String[]{"euclidian distance", "squared distance", "cosine distance", "inverted cosine distance", "angle"};

    public DKNOutlierOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int k = this.getParameterAsInt("number_of_neighbors");
        int n = this.getParameterAsInt("number_of_outliers");
        n -= 2;
        int kindOfDistance = this.getParameterAsInt("distance_function");
        ExampleSet eSet = this.getInput(ExampleSet.class);
        Iterator reader = eSet.iterator();
        int searchSpaceDimension = eSet.getAttributes().size();
        SearchSpace sr = new SearchSpace(searchSpaceDimension, k, k);
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            SearchObject so = new SearchObject(searchSpaceDimension, "object" + counter, k, k + 1);
            ++counter;
            int i = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                so.setVektor(i++, example.getValue(attribute));
            }
            sr.addObject(so);
        }
        LogService.logMessage(String.valueOf(this.getName()) + ": Searching d=" + sr.getDimensions() + " dimensions with k=" + k + " and n=" + n, 2);
        sr.resetOutlierStatus();
        sr.findAllKdContainers(kindOfDistance);
        sr.computeDKN(k, n);
        Attribute outlierAttribute = AttributeFactory.createAttribute("Outlier", 8);
        outlierAttribute.getMapping().mapString("false");
        outlierAttribute.getMapping().mapString("true");
        eSet.getExampleTable().addAttribute(outlierAttribute);
        eSet.getAttributes().setOutlier(outlierAttribute);
        counter = 0;
        for (Example example : eSet) {
            if (sr.getSearchObjectOutlierStatus(counter)) {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("true"));
            } else {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("false"));
            }
            ++counter;
        }
        return new IOObject[]{eSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("number_of_neighbors", "Specifies the k value for the k-th nearest neighbours to be the analyzed.(default value is 10, minimum 1 and max is set to 1 million)", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeInt("number_of_outliers", "The number of top-n Outliers to be looked for.(default value is 10, minimum 2 (internal reasons) and max is set to 1 million)", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeCategory("distance_function", "choose which distance function will be used for calculating the distance between two objects", distanceFunctionList, 0));
        return types;
    }
}

