/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.outlier;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.preprocessing.outlier.SearchObject;
import edu.udo.cs.yale.operator.preprocessing.outlier.SearchSpace;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBOutlierOperator
extends Operator {
    private static final String[] distanceFunctionList = new String[]{"euclidian distance", "squared distance", "cosine distance", "inverted cosine distance", "angle"};

    public DBOutlierOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        double d = this.getParameterAsDouble("distance");
        double p = this.getParameterAsDouble("proportion");
        int kindOfDistance = this.getParameterAsInt("distance_function");
        ExampleSet eSet = this.getInput(ExampleSet.class);
        Iterator reader = eSet.iterator();
        int searchSpaceDimension = eSet.getAttributes().size();
        SearchSpace sr = new SearchSpace(searchSpaceDimension);
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            SearchObject so = new SearchObject(searchSpaceDimension, "object" + counter);
            ++counter;
            int i = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                so.setVektor(i++, example.getValue(attribute));
            }
            sr.addObject(so);
        }
        LogService.logMessage(String.valueOf(this.getName()) + ": Searching d=" + sr.getDimensions() + " dimensions with D=" + d + " distance and p=" + p + " .", 2);
        sr.resetOutlierStatus();
        sr.allRadiusSearch(d, p, kindOfDistance);
        Attribute outlierAttribute = AttributeFactory.createAttribute("Outlier", 8);
        outlierAttribute.getMapping().mapString("false");
        outlierAttribute.getMapping().mapString("true");
        eSet.getExampleTable().addAttribute(outlierAttribute);
        eSet.getAttributes().setOutlier(outlierAttribute);
        counter = 0;
        for (Example example : eSet) {
            if (sr.getSearchObjectOutlierStatus(counter)) {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("true"));
            } else {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("false"));
            }
            ++counter;
        }
        return new IOObject[]{eSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("distance", "The distance for objects.", 0.0, Double.POSITIVE_INFINITY));
        types.add(new ParameterTypeDouble("proportion", "The proportion of objects related to D.", 0.0, 1.0));
        types.add(new ParameterTypeCategory("distance_function", "Indicates which distance function will be used for calculating the distance between two objects", distanceFunctionList, 0));
        return types;
    }
}

