/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.normalization;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.AbstractModel;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.tools.Tools;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZTransformationModel
extends AbstractModel {
    private Map<String, MeanVariance> meanVarianceMap = new HashMap<String, MeanVariance>();

    public void addMeanVariance(String name, double mean, double variance) {
        this.meanVarianceMap.put(name, new MeanVariance(mean, variance));
    }

    public void apply(ExampleSet exampleSet) throws OperatorException {
        for (Example example : exampleSet) {
            for (String name : this.meanVarianceMap.keySet()) {
                MeanVariance mv = this.meanVarianceMap.get(name);
                Attribute attribute = exampleSet.getAttributes().get(name);
                if (mv.variance <= 0.0) {
                    example.setValue(attribute, 0.0);
                    continue;
                }
                double newValue = (example.getValue(attribute) - mv.mean) / Math.sqrt(mv.variance);
                example.setValue(attribute, newValue);
            }
        }
    }

    public String getName() {
        return "Z-Transformation";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Normalize " + this.meanVarianceMap.size() + " attributes to mean 0 and variance 1." + Tools.getLineSeparator() + "Using");
        Iterator<String> i = this.meanVarianceMap.keySet().iterator();
        int counter = 0;
        while (i.hasNext()) {
            if (counter > 4) {
                result.append(String.valueOf(Tools.getLineSeparator()) + "... " + (this.meanVarianceMap.size() - 5) + " more attributes ...");
                break;
            }
            String name = i.next();
            MeanVariance mv = this.meanVarianceMap.get(name);
            result.append(String.valueOf(Tools.getLineSeparator()) + name + " --> mean: " + mv.mean + ", variance: " + mv.variance);
            ++counter;
        }
        return result.toString();
    }

    private static class MeanVariance {
        double mean = 0.0;
        double variance = 1.0;

        public MeanVariance(double mean, double variance) {
            this.mean = mean;
            this.variance = variance;
        }
    }
}

