/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.normalization;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.preprocessing.PreprocessingOperator;
import edu.udo.cs.yale.operator.preprocessing.normalization.MinMaxNormalizationModel;
import edu.udo.cs.yale.operator.preprocessing.normalization.ZTransformationModel;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Normalization
extends PreprocessingOperator {
    public Normalization(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        if (this.getParameterAsBoolean("z_transform")) {
            exampleSet.recalculateAllAttributeStatistics();
            ZTransformationModel model = new ZTransformationModel();
            for (Attribute attribute : exampleSet.getAttributes()) {
                model.addMeanVariance(attribute.getName(), ((NumericalAttributeStatistics)attribute.getStatistics()).getAverage(), ((NumericalAttributeStatistics)attribute.getStatistics()).getVariance());
            }
            return model;
        }
        double min = this.getParameterAsDouble("min");
        double max = this.getParameterAsDouble("max");
        if (max < min) {
            throw new UserError((Operator)this, 116, "max", (Object)"Must not be smaller than 'min'");
        }
        return new MinMaxNormalizationModel(min, max);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean("z_transform", "Determines whether to perform a z-transformation (mean 0 and variance 1) or not; this scaling ignores min- and max-setings", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("min", "The minimum value after normalization", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble("max", "The maximum value after normalization", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }
}

