/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.normalization;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.AbstractModel;
import edu.udo.cs.yale.operator.OperatorException;

public class MinMaxNormalizationModel
extends AbstractModel {
    private double min;
    private double max;

    public MinMaxNormalizationModel() {
    }

    public MinMaxNormalizationModel(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public void apply(ExampleSet exampleSet) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        for (Example example : exampleSet) {
            for (Attribute attribute : exampleSet.getAttributes()) {
                double value = example.getValue(attribute);
                double minA = ((NumericalAttributeStatistics)attribute.getStatistics()).getMinimum();
                double maxA = ((NumericalAttributeStatistics)attribute.getStatistics()).getMaximum();
                double result = 0.0;
                if (maxA - minA != 0.0 && this.max - this.min != 0.0) {
                    result = (value - minA) / (maxA - minA) * (this.max - this.min) + this.min;
                }
                example.setValue(attribute, result);
            }
        }
    }

    public String getName() {
        return "MinMaxNormalizationModel";
    }

    public String toString() {
        return "Normalize between " + this.min + " and " + this.max;
    }
}

