/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueReplenishment
extends Operator {
    public ValueReplenishment(OperatorDescription description) {
        super(description);
    }

    public abstract boolean replenishValue(double var1);

    public abstract double getReplenishmentValue(int var1, Attribute var2, double var3, String var5);

    public abstract String[] getFunctionNames();

    public abstract int getDefaultFunction();

    public abstract int getDefaultColumnFunction();

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = this.getInput(ExampleSet.class);
        eSet.recalculateAllAttributeStatistics();
        int[] replenishmentFunctions = new int[eSet.getAttributes().size()];
        int j = 0;
        while (j < replenishmentFunctions.length) {
            replenishmentFunctions[j] = this.getParameterAsInt("default");
            ++j;
        }
        for (Object[] pair : this.getParameterList("columns")) {
            String name = (String)pair[0];
            Integer replenishmentFunctionIndex = (Integer)pair[1];
            int j2 = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                if (attribute.getName().equals(name)) {
                    replenishmentFunctions[j2] = replenishmentFunctionIndex;
                }
                ++j2;
            }
        }
        for (Example example : eSet) {
            int j3 = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                double value = example.getValue(attribute);
                if (this.replenishValue(value)) {
                    example.setValue(attribute, this.getReplenishmentValue(replenishmentFunctions[j3], attribute, value, this.getParameterAsString("replenishment_value")));
                }
                ++j3;
            }
            this.checkForStop();
        }
        return new IOObject[]{eSet};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory("default", "Function to apply to all columns that are not explicitly specified by parameter 'columns'.", this.getFunctionNames(), this.getDefaultFunction());
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeList("columns", "List of replacement functions for each column.", new ParameterTypeCategory("replace_with", "The key is the attribute name. The value is the name of function used to replace the missing value.", this.getFunctionNames(), this.getDefaultColumnFunction())));
        types.add(new ParameterTypeString("replenishment_value", "This value is used for some of the replenishment types.", true));
        return types;
    }
}

