/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.preprocessing.filter.Series2WindowExamples;
import edu.udo.cs.yale.tools.LogService;

public class UnivariateSeries2WindowExamples
extends Series2WindowExamples {
    public UnivariateSeries2WindowExamples(OperatorDescription description) {
        super(description);
    }

    public int getNumberOfAttributes(ExampleSet exampleSet, int representation, int windowWidth) {
        return windowWidth;
    }

    public void performChecks(ExampleSet exampleSet, int representation, int windowWidth, int stepSize, int horizon) throws OperatorException {
        if (representation == 0) {
            if (exampleSet.getAttributes().size() != 1) {
                throw new UserError((Operator)this, 133, (Object)1, (Object)exampleSet.getAttributes().size());
            }
            if (exampleSet.size() < windowWidth + horizon) {
                throw new UserError((Operator)this, 110, "window width + horizon = " + (windowWidth + horizon));
            }
        } else {
            if (exampleSet.size() != 1) {
                LogService.logMessage("The sliding windows will be applied on each example of the example set, if you intended to perform a multivariate series2examples transformation, please use the corresponding operator", 4);
            }
            if (exampleSet.getAttributes().size() < windowWidth + horizon) {
                throw new UserError((Operator)this, 125, (Object)exampleSet.getAttributes().size(), (Object)(windowWidth + horizon));
            }
        }
    }

    public void fillSeriesExampleTable(MemoryExampleTable table, ExampleSet exampleSet, Attribute label, int representation, int windowWidth, int stepSize, int horizon) throws OperatorException {
        if (representation == 0) {
            Attribute seriesAttribute = exampleSet.getAttributes().iterator().next();
            int w = 0;
            while (w < exampleSet.size() - windowWidth - horizon) {
                double[] data = new double[windowWidth + 1];
                int d = 0;
                while (d < data.length - 1) {
                    data[d] = exampleSet.getExample(w + d).getValue(seriesAttribute);
                    ++d;
                }
                data[data.length - 1] = exampleSet.getExample(w + windowWidth + horizon).getValue(seriesAttribute);
                table.addDataRow(new DoubleArrayDataRow(data));
                this.checkForStop();
                w += stepSize;
            }
        } else {
            Attribute[] attributeArray = exampleSet.getAttributes().createRegularAttributeArray();
            int lastAttribute = exampleSet.getAttributes().size() - windowWidth - horizon;
            for (Example example : exampleSet) {
                int w = 0;
                while (w < lastAttribute) {
                    double[] data = new double[windowWidth + 1];
                    int d = 0;
                    while (d < data.length - 1) {
                        data[d] = example.getValue(attributeArray[w + d]);
                        ++d;
                    }
                    data[data.length - 1] = example.getValue(attributeArray[w + windowWidth + horizon]);
                    table.addDataRow(new DoubleArrayDataRow(data));
                    this.checkForStop();
                    w += stepSize;
                }
            }
        }
    }
}

