/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFIDFFilter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public TFIDFFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int i;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        if (exampleSet.size() < 1) {
            throw new UserError((Operator)this, 110, new Object[]{"1"});
        }
        if (exampleSet.getAttributes().size() == 0) {
            throw new UserError((Operator)this, 106, new Object[0]);
        }
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) continue;
            throw new UserError((Operator)this, 104, new Object[]{this.getName(), attribute.getName()});
        }
        double[] termFrequencySum = new double[exampleSet.size()];
        int[] documentFrequencies = new int[exampleSet.getAttributes().size()];
        int exampleCounter = 0;
        for (Example example : exampleSet) {
            i = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double value = example.getValue(attribute);
                int n = exampleCounter;
                termFrequencySum[n] = termFrequencySum[n] + value;
                if (value > 0.0) {
                    int n2 = i;
                    documentFrequencies[n2] = documentFrequencies[n2] + 1;
                }
                ++i;
            }
            ++exampleCounter;
            this.checkForStop();
        }
        double[] inverseDocumentFrequencies = new double[documentFrequencies.length];
        i = 0;
        while (i < exampleSet.getAttributes().size()) {
            inverseDocumentFrequencies[i] = Math.log((double)exampleSet.size() / (double)documentFrequencies[i]);
            ++i;
        }
        boolean calculateTermFrequencies = this.getParameterAsBoolean("calculate_term_frequencies");
        exampleCounter = 0;
        for (Example example : exampleSet) {
            int i2 = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double value = example.getValue(attribute);
                if (termFrequencySum[exampleCounter] == 0.0) {
                    example.setValue(attribute, 0.0);
                } else {
                    double tf = value;
                    if (calculateTermFrequencies) {
                        value /= termFrequencySum[exampleCounter];
                    }
                    double idf = inverseDocumentFrequencies[i2];
                    example.setValue(attribute, tf * idf);
                }
                ++i2;
            }
            ++exampleCounter;
            this.checkForStop();
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean("calculate_term_frequencies", "Indicates if term frequency values should be generated (must be done if input data is given as simple occurence counts).", true);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

