/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SortedExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sorting
extends Operator {
    public Sorting(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int sortingDirection = this.getParameterAsInt("sorting_direction");
        Attribute sortingAttribute = exampleSet.getAttributes().get(this.getParameterAsString("attribute_name"));
        if (sortingAttribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString("attribute_name"));
        }
        SortedExampleSet result = new SortedExampleSet(exampleSet, sortingAttribute, sortingDirection);
        return new IOObject[]{result};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString("attribute_name", "Indicates the attribute which should be used for determining the sorting.", false));
        types.add(new ParameterTypeCategory("sorting_direction", "Indicates the direction of the sorting.", SortedExampleSet.SORTING_DIRECTIONS, 0));
        return types;
    }
}

