/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Series2WindowExamples
extends Operator {
    public static final String[] SERIES_REPRESENTATIONS = new String[]{"encode_series_by_examples", "encode_series_by_attributes"};
    public static final int SERIES_AS_EXAMPLES = 0;
    public static final int SERIES_AS_ATTRIBUTES = 1;

    public Series2WindowExamples(OperatorDescription description) {
        super(description);
    }

    public abstract void performChecks(ExampleSet var1, int var2, int var3, int var4, int var5) throws OperatorException;

    public abstract void fillSeriesExampleTable(MemoryExampleTable var1, ExampleSet var2, Attribute var3, int var4, int var5, int var6, int var7) throws OperatorException;

    public abstract int getNumberOfAttributes(ExampleSet var1, int var2, int var3);

    @Override
    public IOObject[] apply() throws OperatorException {
        int i;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int representation = this.getParameterAsInt("series_representation");
        int horizon = this.getParameterAsInt("horizon") - 1;
        int windowWidth = this.getParameterAsInt("window_size");
        int stepSize = this.getParameterAsInt("step_size");
        this.performChecks(exampleSet, representation, windowWidth, stepSize, horizon);
        int valueType = -1;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (valueType < 0) {
                valueType = attribute.getValueType();
                continue;
            }
            if (attribute.getValueType() == valueType) continue;
            throw new UserError(this, 126);
        }
        int numberOfResultingAttributes = this.getNumberOfAttributes(exampleSet, representation, windowWidth);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(numberOfResultingAttributes + 1);
        if (this.getParameterAsBoolean("create_single_attributes")) {
            i = 0;
            while (i < numberOfResultingAttributes) {
                attributes.add(AttributeFactory.createAttribute("series" + i, valueType));
                ++i;
            }
        } else {
            attributes.add(AttributeFactory.createAttribute("series0", valueType, 7));
            i = 1;
            while (i < numberOfResultingAttributes - 1) {
                attributes.add(AttributeFactory.createAttribute("series" + i, valueType, 1));
                ++i;
            }
            attributes.add(AttributeFactory.createAttribute("series" + (numberOfResultingAttributes - 1), valueType, 8));
        }
        Attribute label = AttributeFactory.createAttribute("label", valueType);
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        this.fillSeriesExampleTable(table, exampleSet, label, representation, windowWidth, stepSize, horizon);
        ExampleSet result = table.createExampleSet(label);
        return new IOObject[]{result};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("series_representation", "This parameter defines how the series values will be represented.", SERIES_REPRESENTATIONS, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("horizon", "The prediction horizon, i.e. the distance between the last window value and the value to predict.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("window_size", "The width of the used windows.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("step_size", "The step size of the used windows, i.e. the distance between the first values", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeBoolean("create_single_attributes", "Indicates if the result example set should use single attributes instead of series attributes.", true));
        return types;
    }
}

