/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import java.util.ArrayList;

public class PermutationOperator
extends Operator {
    public PermutationOperator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        ExampleTable table = exampleSet.getExampleTable();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeList.add((Attribute)attribute.clone());
        }
        int toCopy = table.size();
        MemoryExampleTable shuffledTable = new MemoryExampleTable(attributeList);
        DataRow[] isCopied = new DataRow[toCopy];
        int areCopied = 0;
        DataRowReader reader = table.getDataRowReader();
        while (areCopied < toCopy) {
            int currentRow = (int)Math.round(Math.random() * (double)(toCopy - 1));
            if (isCopied[currentRow] == null) {
                isCopied[currentRow] = (DataRow)reader.next();
                ++areCopied;
            }
            this.checkForStop();
        }
        int i = 0;
        while (i < toCopy) {
            shuffledTable.addDataRow(isCopied[i]);
            ++i;
        }
        return new IOObject[]{shuffledTable.createExampleSet(exampleSet.getAttributes().specialAttributes())};
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }
}

