/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumericToNominal
extends Operator {
    public NumericToNominal(OperatorDescription description) {
        super(description);
    }

    protected abstract void setValue(Example var1, Attribute var2, double var3) throws OperatorException;

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Map<Attribute, Attribute> trans = this.buildTranslationMap(exampleSet);
        for (Example example : exampleSet) {
            for (Map.Entry<Attribute, Attribute> e : trans.entrySet()) {
                Attribute oldAttribute = e.getKey();
                Attribute newAttribute = e.getValue();
                double value = example.getValue(oldAttribute);
                this.setValue(example, newAttribute, value);
            }
            this.checkForStop();
        }
        return new IOObject[]{exampleSet};
    }

    private void buildTranslationMap(ExampleSet exampleSet, Map<Attribute, Attribute> trans, Attribute old) {
        if (!old.isNominal()) {
            Attribute _new = exampleSet.getAttributes().replace(old, AttributeFactory.changeValueType(old, 1));
            trans.put(old, _new);
        }
    }

    private Map<Attribute, Attribute> buildTranslationMap(ExampleSet exampleSet) {
        HashMap<Attribute, Attribute> trans = new HashMap<Attribute, Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.buildTranslationMap(exampleSet, trans, attribute);
        }
        return trans;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }
}

