/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DoubleSparseArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NominalToBinary
extends Operator {
    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_NUMERICAL = 1;

    public NominalToBinary(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int type = this.getParameterAsBoolean("create_numerical_attributes") ? 1 : 0;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.isNominal() && attribute.getMapping().getValues().size() > 2) {
                this.handleNominalAttribute(attribute, attributes, type);
                continue;
            }
            attributes.add((Attribute)attribute.clone());
        }
        HashMap<Attribute, String> specialAttributeMap = new HashMap<Attribute, String>();
        Iterator<AttributeRole> i = exampleSet.getAttributes().specialAttributes();
        while (i.hasNext()) {
            AttributeRole role = i.next();
            String specialName = role.getSpecialName();
            Attribute special = role.getAttribute();
            Attribute newSpecial = (Attribute)special.clone();
            attributes.add(newSpecial);
            specialAttributeMap.put(newSpecial, specialName);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (Example example : exampleSet) {
            int index = 0;
            DoubleSparseArrayDataRow dataRow = new DoubleSparseArrayDataRow(example.getAttributes().size());
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (attribute.isNominal() && attribute.getMapping().getValues().size() > 2) {
                    int trueAttributeIndex = (int)example.getValue(attribute);
                    Attribute currentNewAttribute = (Attribute)attributes.get(index + trueAttributeIndex);
                    if (type == 1) {
                        dataRow.set(currentNewAttribute, 1.0);
                    } else if (type == 0) {
                        dataRow.set(currentNewAttribute, currentNewAttribute.getMapping().mapString("true"));
                    }
                    index += attribute.getMapping().getValues().size();
                    continue;
                }
                dataRow.set((Attribute)attributes.get(index++), example.getValue(attribute));
            }
            Iterator<AttributeRole> s = exampleSet.getAttributes().specialAttributes();
            while (s.hasNext()) {
                Attribute special = s.next().getAttribute();
                dataRow.set((Attribute)attributes.get(index++), example.getValue(special));
            }
            ((DataRow)dataRow).trim();
            table.addDataRow(dataRow);
            this.checkForStop();
        }
        ExampleSet resultSet = table.createExampleSet(specialAttributeMap);
        return new IOObject[]{resultSet};
    }

    public void handleNominalAttribute(Attribute attribute, List<Attribute> attributeList, int type) {
        for (String nominalValue : attribute.getMapping().getValues()) {
            Attribute newAttribute = null;
            if (type == 0) {
                newAttribute = AttributeFactory.createAttribute(String.valueOf(attribute.getName()) + "_" + nominalValue, 8, 3);
                if (newAttribute.getMapping().mapString("false") != 0) {
                    LogService.logMessage("Nominal2Binary filtering: 'false' was not mapped to the first attribute value index!", 4);
                }
                newAttribute.getMapping().mapString("true");
            } else if (type == 1) {
                newAttribute = AttributeFactory.createAttribute(String.valueOf(attribute.getName()) + "_" + nominalValue, 2, 3);
            }
            attributeList.add(newAttribute);
        }
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("create_numerical_attributes", "Indicates if numerical attributes should be created instead of boolean attributes.", false));
        return types;
    }
}

