/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.preprocessing.filter.Series2WindowExamples;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultivariateSeries2WindowExamples
extends Series2WindowExamples {
    public MultivariateSeries2WindowExamples(OperatorDescription description) {
        super(description);
    }

    @Override
    public int getNumberOfAttributes(ExampleSet exampleSet, int representation, int windowWidth) {
        if (representation == 0) {
            return windowWidth * exampleSet.getAttributes().size();
        }
        return windowWidth * exampleSet.size();
    }

    @Override
    public void performChecks(ExampleSet exampleSet, int representation, int windowWidth, int stepSize, int horizon) throws OperatorException {
        if (representation == 0) {
            if (exampleSet.size() < windowWidth + horizon) {
                throw new UserError((Operator)this, 110, "window width + horizon = " + (windowWidth + horizon));
            }
        } else if (exampleSet.getAttributes().size() < windowWidth + horizon) {
            throw new UserError((Operator)this, 125, (Object)exampleSet.getAttributes().size(), (Object)(windowWidth + horizon));
        }
    }

    @Override
    public void fillSeriesExampleTable(MemoryExampleTable table, ExampleSet exampleSet, Attribute label, int representation, int windowWidth, int stepSize, int horizon) throws OperatorException {
        int labelDimension = this.getParameterAsInt("label_dimension");
        if (representation == 0) {
            int w = 0;
            while (w < exampleSet.size() - windowWidth - horizon) {
                double[] data = new double[windowWidth * exampleSet.getAttributes().size() + 1];
                int a = 0;
                for (Attribute currentAttribute : exampleSet.getAttributes()) {
                    int d = 0;
                    while (d < windowWidth) {
                        data[a * windowWidth + d] = exampleSet.getExample(w + d).getValue(currentAttribute);
                        ++d;
                    }
                    if (a != labelDimension) continue;
                    data[data.length - 1] = exampleSet.getExample(w + windowWidth + horizon).getValue(currentAttribute);
                }
                table.addDataRow(new DoubleArrayDataRow(data));
                this.checkForStop();
                ++a;
                w += stepSize;
            }
        } else {
            int lastAttribute = exampleSet.getAttributes().size() - windowWidth - horizon;
            Attribute[] attributeArray = new Attribute[exampleSet.getAttributes().size()];
            int index = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                attributeArray[index++] = attribute;
            }
            int w = 0;
            while (w < lastAttribute) {
                double[] data = new double[windowWidth * exampleSet.size() + 1];
                int counter = 0;
                for (Example example : exampleSet) {
                    int d = 0;
                    while (d < windowWidth) {
                        data[counter * windowWidth + d] = example.getValue(attributeArray[w + d]);
                        ++d;
                    }
                    if (counter == labelDimension) {
                        data[data.length - 1] = example.getValue(attributeArray[w + windowWidth + horizon]);
                    }
                    ++counter;
                }
                table.addDataRow(new DoubleArrayDataRow(data));
                this.checkForStop();
                w += stepSize;
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("label_dimension", "The dimension which should be used for creating the label values (counting starts with 0).", 0, Integer.MAX_VALUE, false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

