/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.NominalAttributeStatistics;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.preprocessing.filter.ValueReplenishment;

public class MissingValueReplenishment
extends ValueReplenishment {
    private static final int NONE = 0;
    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 2;
    private static final int AVERAGE = 3;
    private static final int ZERO = 4;
    private static final int VALUE = 5;
    private static final String[] REPLENISHMENT_NAMES = new String[]{"none", "minimum", "maximum", "average", "zero", "value"};

    public MissingValueReplenishment(OperatorDescription description) {
        super(description);
    }

    public String[] getFunctionNames() {
        return REPLENISHMENT_NAMES;
    }

    public int getDefaultFunction() {
        return 3;
    }

    public int getDefaultColumnFunction() {
        return 3;
    }

    public boolean replenishValue(double currentValue) {
        return Double.isNaN(currentValue);
    }

    public double getReplenishmentValue(int functionIndex, Attribute attribute, double currentValue, String valueString) {
        switch (functionIndex) {
            case 0: {
                return currentValue;
            }
            case 1: {
                return ((NumericalAttributeStatistics)attribute.getStatistics()).getMinimum();
            }
            case 2: {
                return ((NumericalAttributeStatistics)attribute.getStatistics()).getMaximum();
            }
            case 3: {
                if (attribute.isNominal()) {
                    return ((NominalAttributeStatistics)attribute.getStatistics()).getMode();
                }
                return ((NumericalAttributeStatistics)attribute.getStatistics()).getAverage();
            }
            case 4: {
                return 0.0;
            }
            case 5: {
                if (attribute.isNominal()) {
                    return attribute.getMapping().mapString(valueString);
                }
                return Double.parseDouble(valueString);
            }
        }
        throw new RuntimeException("Illegal value functionIndex: " + functionIndex);
    }
}

