/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.ConditionCreationException;
import edu.udo.cs.yale.example.ConditionExampleReader;
import edu.udo.cs.yale.example.ConditionedExampleSet;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.condition.CombinedInnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SpecificInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingValueImputation
extends OperatorChain {
    private static final int CHRONOLOGICAL = 0;
    private static final int RANDOM = 1;
    private static final int INFORMATION_GAIN = 2;
    private static final String[] orderStrategies = new String[]{"chronological", "random", "information gain"};

    public MissingValueImputation(OperatorDescription description) {
        super(description);
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        int i = 0;
        while (i < this.getNumberOfOperators() - 2) {
            condition.addCondition(new SpecificInnerOperatorCondition("Filter" + i, i, new Class[]{ExampleSet.class}, new Class[]{ExampleSet.class}));
            ++i;
        }
        condition.addCondition(new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        return condition;
    }

    private Operator getLearner() {
        return this.getOperator(this.getNumberOfOperators() - 1);
    }

    private Attribute[] getOrderedAttributes(ExampleSet exampleSet, int order) throws OperatorException {
        int numberOfAttributes = exampleSet.getAttributes().size();
        Attribute[] orderedAttributes = new Attribute[numberOfAttributes];
        Attribute[] originalAttributes = new Attribute[numberOfAttributes];
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            originalAttributes[index++] = attribute;
        }
        switch (order) {
            case 0: {
                int i = 0;
                while (i < orderedAttributes.length) {
                    orderedAttributes[i] = originalAttributes[i];
                    ++i;
                }
                break;
            }
            case 1: {
                double[] attr_probs = new double[numberOfAttributes];
                int j = 0;
                while (j < attr_probs.length) {
                    attr_probs[j] = 1.0 / (double)attr_probs.length;
                    ++j;
                }
                int i = 0;
                while (i < numberOfAttributes) {
                    int currAttributeIndex = RandomGenerator.getGlobalRandomGenerator().randomIndex(attr_probs);
                    attr_probs[currAttributeIndex] = 0.0;
                    int j2 = 0;
                    while (j2 < attr_probs.length) {
                        if (attr_probs[j2] != 0.0) {
                            attr_probs[j2] = 1.0 / (double)(attr_probs.length - i - 1);
                        }
                        ++j2;
                    }
                    orderedAttributes[i] = originalAttributes[currAttributeIndex];
                    ++i;
                }
                break;
            }
            case 2: {
                Operator infoGainEvaluator;
                if (exampleSet.getAttributes().getLabel() == null) {
                    throw new UserError(this, 105);
                }
                AttributeWeights infoGains = null;
                try {
                    infoGainEvaluator = OperatorService.createOperator("InfoGainAttributeEval");
                }
                catch (OperatorCreationException e) {
                    throw new OperatorException();
                }
                infoGains = infoGainEvaluator.apply(new IOContainer(new IOObject[]{exampleSet})).get(AttributeWeights.class);
                Object[] attribNamesObj = infoGains.getAttributeNames().toArray();
                String[] attributeNames = new String[numberOfAttributes];
                int i = 0;
                while (i < numberOfAttributes) {
                    attributeNames[i] = (String)attribNamesObj[i];
                    ++i;
                }
                infoGains.sortByWeight(attributeNames, -1, 1);
                i = 0;
                while (i < attributeNames.length) {
                    orderedAttributes[i] = exampleSet.getAttributes().get(attributeNames[i]);
                    ++i;
                }
                break;
            }
        }
        return orderedAttributes;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        boolean iterate = this.getParameterAsBoolean("iterate");
        int order = this.getParameterAsInt("order");
        boolean filterLearningSet = this.getParameterAsBoolean("filter_learning_set");
        boolean learnOnCompleteCases = this.getParameterAsBoolean("learn_on_complete_cases");
        ExampleSet sourceSet = this.getInput(ExampleSet.class);
        sourceSet.recalculateAllAttributeStatistics();
        ExampleSet originalSet = (ExampleSet)sourceSet.clone();
        Attribute labelAttribute = originalSet.getAttributes().getLabel();
        if (labelAttribute != null) {
            originalSet.getAttributes().remove(labelAttribute);
        }
        ExampleSet learningSet = (ExampleSet)originalSet.clone();
        ExampleSet substitutionSet = (ExampleSet)originalSet.clone();
        int i = 0;
        while (i < this.getNumberOfOperators() - 1) {
            ExampleSet bufferSet;
            substitutionSet = bufferSet = this.getOperator(i).apply(new IOContainer(new IOObject[]{originalSet})).get(ExampleSet.class);
            ++i;
        }
        int numberOfAttributes = substitutionSet.getAttributes().size();
        Attribute[][] attributePairs = new Attribute[2][numberOfAttributes];
        substitutionSet.getAttributes().setLabel(labelAttribute);
        attributePairs[0] = this.getOrderedAttributes(substitutionSet, order);
        substitutionSet.getAttributes().setLabel(null);
        ExampleSet eSet = null;
        int i2 = 0;
        while (i2 < numberOfAttributes) {
            eSet = (ExampleSet)learningSet.clone();
            if (filterLearningSet) {
                eSet = (ExampleSet)substitutionSet.clone();
            }
            Attribute currAttribute = attributePairs[0][i2];
            System.err.println(String.valueOf(i2) + ": " + currAttribute.getName());
            eSet.getAttributes().setLabel(currAttribute);
            Condition condition = null;
            try {
                condition = ConditionExampleReader.createCondition("no_missing_labels", eSet, "");
            }
            catch (ConditionCreationException e) {
                throw new UserError((Operator)this, 904, "no_missing_lables", (Object)e.getMessage());
            }
            ConditionedExampleSet superSet = new ConditionedExampleSet(eSet, condition);
            if (learnOnCompleteCases) {
                try {
                    condition = ConditionExampleReader.createCondition("no_missing_attributes", superSet, "");
                }
                catch (ConditionCreationException e) {
                    throw new UserError((Operator)this, 904, "no_missing_attributes", (Object)e.getMessage());
                }
                superSet = new ConditionedExampleSet(superSet, condition);
            }
            Model model = this.getLearner().apply(new IOContainer(new IOObject[]{superSet})).get(Model.class);
            eSet.getAttributes().setLabel(null);
            eSet.getAttributes().addRegular(currAttribute);
            model.apply(eSet);
            attributePairs[1][i2] = eSet.getAttributes().getPredictedLabel();
            if (iterate) {
                for (Example example : eSet) {
                    double value = example.getValue(currAttribute);
                    if (!Double.isNaN(value)) continue;
                    example.setValue(currAttribute, example.getPredictedLabel());
                }
            }
            eSet.getAttributes().setPredictedLabel(null);
            ++i2;
        }
        if (!iterate) {
            i2 = 0;
            while (i2 < numberOfAttributes) {
                for (Example example : eSet) {
                    double value = example.getValue(attributePairs[0][i2]);
                    if (!Double.isNaN(value)) continue;
                    example.setValue(attributePairs[0][i2], example.getValue(attributePairs[1][i2]));
                }
                ++i2;
            }
        }
        return new IOObject[]{sourceSet};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("order", "Order of attributes in which missing values are estimated.", orderStrategies, 0));
        types.add(new ParameterTypeBoolean("iterate", "Impute missing values immediately after having learned the corresponding concept and iterate.", true));
        types.add(new ParameterTypeBoolean("filter_learning_set", "Apply filter to learning set in addition to determination which missing values should be substituted.", false));
        types.add(new ParameterTypeBoolean("learn_on_complete_cases", "Learn concepts to impute missing values only on the basis of complete cases (should be used in case learning approach can not handle missing values).", true));
        return types;
    }
}

