/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeNominalValues
extends Operator {
    public MergeNominalValues(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        String name = this.getParameterAsString("attribute_name");
        Attribute attribute = null;
        for (Attribute current : exampleSet.getAttributes()) {
            if (!current.getName().equals(name)) continue;
            if (!current.isNominal()) {
                throw new UserError((Operator)this, 119, new Object[]{name, this.getName()});
            }
            attribute = current;
            break;
        }
        if (attribute == null) {
            throw new UserError((Operator)this, 111, name);
        }
        String firstValue = this.getParameterAsString("first_value");
        String secondValue = this.getParameterAsString("second_value");
        this.mergeValues(exampleSet, attribute, firstValue, secondValue);
        return new IOObject[]{exampleSet};
    }

    private void mergeValues(ExampleSet exampleSet, Attribute attribute, String firstValue, String secondValue) throws OperatorException {
        Attribute newAttribute = AttributeFactory.createAttribute(attribute, "merged");
        newAttribute.getMapping().clear();
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        double first = attribute.getMapping().mapString(firstValue);
        double second = attribute.getMapping().mapString(secondValue);
        String firstPlusSecondString = String.valueOf(firstValue) + "_" + secondValue;
        for (Example example : exampleSet) {
            double value = example.getValue(attribute);
            if (Double.isNaN(value)) {
                example.setValue(newAttribute, Double.NaN);
            } else if (value == first || value == second) {
                example.setValue(newAttribute, newAttribute.getMapping().mapString(firstPlusSecondString));
            } else {
                example.setValue(newAttribute, newAttribute.getMapping().mapString(attribute.getMapping().mapIndex((int)value)));
            }
            this.checkForStop();
        }
        exampleSet.getAttributes().remove(attribute);
        newAttribute.setName(attribute.getName());
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString("attribute_name", "The name of the nominal attribute which values should be merged.", false));
        types.add(new ParameterTypeString("first_value", "The first value which should be merged.", false));
        types.add(new ParameterTypeString("second_value", "The second value which should be merged.", false));
        return types;
    }
}

