/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import java.util.Iterator;

public class LabelTrend2Classification
extends Operator {
    public LabelTrend2Classification(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label == null) {
            throw new UserError(this, 105);
        }
        if (label.isNominal()) {
            throw new UserError((Operator)this, 102, this.getName(), (Object)label.getName());
        }
        Attribute newLabel = AttributeFactory.createAttribute("label", 8);
        newLabel.getMapping().mapString("up");
        newLabel.getMapping().mapString("down");
        exampleSet.getExampleTable().addAttribute(newLabel);
        exampleSet.getAttributes().addRegular(newLabel);
        Iterator i = exampleSet.iterator();
        double lastValue = 0.0;
        while (i.hasNext()) {
            Example example = (Example)i.next();
            double currentValue = example.getLabel();
            if (currentValue > lastValue) {
                example.setValue(newLabel, "up");
            } else {
                example.setValue(newLabel, "down");
            }
            lastValue = currentValue;
        }
        exampleSet.getAttributes().remove(newLabel);
        exampleSet.getAttributes().setLabel(newLabel);
        return new IOObject[]{exampleSet};
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }
}

