/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.preprocessing.filter.FeatureFilter;
import edu.udo.cs.yale.tools.Ontology;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureValueTypeFilter
extends FeatureFilter {
    public FeatureValueTypeFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean switchOffFeature(Attribute feature) throws OperatorException {
        int type = this.getParameterAsInt("skip_features_of_type") + 1;
        int exceptionType = this.getParameterAsInt("except_features_of_type");
        if (exceptionType == 0) {
            return Ontology.ATTRIBUTE_VALUE_TYPE.isA(feature.getValueType(), type);
        }
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(feature.getValueType(), type) && !Ontology.ATTRIBUTE_VALUE_TYPE.isA(feature.getValueType(), exceptionType);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        String[] valueTypes = new String[Ontology.VALUE_TYPE_NAMES.length - 1];
        int i = 0;
        while (i < valueTypes.length) {
            valueTypes[i] = Ontology.VALUE_TYPE_NAMES[i + 1];
            ++i;
        }
        ParameterTypeCategory type = new ParameterTypeCategory("skip_features_of_type", "All features of this type will be deselected.", valueTypes, 0);
        type.setExpert(false);
        types.add(type);
        String[] exceptionValueTypes = new String[valueTypes.length + 1];
        exceptionValueTypes[0] = "none";
        System.arraycopy(valueTypes, 0, exceptionValueTypes, 1, valueTypes.length);
        types.add(new ParameterTypeCategory("except_features_of_type", "All features of this type will not be deselected.", exceptionValueTypes, 0));
        return types;
    }
}

