/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureRangeRemoval
extends Operator {
    public FeatureRangeRemoval(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int first = this.getParameterAsInt("first_attribute") - 1;
        int last = this.getParameterAsInt("last_attribute") - 1;
        if (last < first) {
            LogService.logMessage("Last attribute is smaller than first. No change performed.", 4);
        }
        if (last >= exampleSet.getAttributes().size()) {
            throw new UserError((Operator)this, 125, String.valueOf(exampleSet.getAttributes().size()), (Object)String.valueOf(last + 1));
        }
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        int counter = 0;
        while (i.hasNext() && counter <= last) {
            i.next();
            if (counter >= first && counter <= last) {
                i.remove();
            }
            this.checkForStop();
            ++counter;
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameterTypes = super.getParameterTypes();
        ParameterTypeInt parameterType = new ParameterTypeInt("first_attribute", "The first attribute of the attribute range which should  be removed", 1, Integer.MAX_VALUE, false);
        parameterType.setExpert(false);
        parameterTypes.add(parameterType);
        parameterType = new ParameterTypeInt("last_attribute", "The last attribute of the attribute range which should  be removed", 1, Integer.MAX_VALUE, false);
        parameterType.setExpert(false);
        parameterTypes.add(parameterType);
        return parameterTypes;
    }
}

