/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.preprocessing.filter.FeatureFilter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureNameFilter
extends FeatureFilter {
    private Pattern skipPattern;
    private Pattern exceptionPattern;

    public FeatureNameFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        String regex = this.getParameterAsString("skip_features_with_name");
        try {
            this.skipPattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, regex, (Object)e.getMessage());
        }
        regex = this.getParameterAsString("except_features_with_name");
        if (regex == null || regex.trim().length() == 0) {
            this.exceptionPattern = null;
        } else {
            try {
                this.exceptionPattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new UserError((Operator)this, 206, regex, (Object)e.getMessage());
            }
        }
        return super.apply();
    }

    @Override
    public boolean switchOffFeature(Attribute feature) throws OperatorException {
        Matcher exceptionMatcher;
        Matcher skipMatcher = this.skipPattern.matcher(feature.getName());
        Matcher matcher = exceptionMatcher = this.exceptionPattern != null ? this.exceptionPattern.matcher(feature.getName()) : null;
        return skipMatcher.matches() && (exceptionMatcher == null || !exceptionMatcher.matches());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString("skip_features_with_name", "Remove attributes with a matching name (accepts regular expressions)", false));
        types.add(new ParameterTypeString("except_features_with_name", "Does not remove attributes if their name fulfills this matching criterion (accepts regular expressions)", true));
        return types;
    }
}

