/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureFilter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public FeatureFilter(OperatorDescription description) {
        super(description);
    }

    public abstract boolean switchOffFeature(Attribute var1) throws OperatorException;

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = this.getInput(ExampleSet.class);
        LogService.logMessage("FeatureFilter: " + eSet.getAttributes().size() + " features before filtering.", 2);
        Iterator<Attribute> i = eSet.getAttributes().iterator();
        if (this.getParameterAsBoolean("filter_special_features")) {
            i = eSet.getAttributes().allAttributes();
        }
        while (i.hasNext()) {
            if (this.switchOffFeature(i.next())) {
                i.remove();
            }
            this.checkForStop();
        }
        LogService.logMessage("FeatureFilter: " + eSet.getAttributes().size() + " features left after filtering.", 2);
        return new IOObject[]{eSet};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("filter_special_features", "Filter also special attributes (label, id...)", false));
        return types;
    }
}

