/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Partition;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleRangeFilter
extends Operator {
    public ExampleRangeFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int[] partition = new int[exampleSet.size()];
        int startIndex = this.getParameterAsInt("first_example");
        int endIndex = this.getParameterAsInt("last_example");
        if (endIndex < startIndex) {
            throw new UserError((Operator)this, 210, "last_example", (Object)"first_example");
        }
        int i = 0;
        while (i < partition.length) {
            partition[i] = i >= startIndex - 1 && i <= endIndex - 1 ? 0 : 1;
            ++i;
        }
        SplittedExampleSet result = new SplittedExampleSet(exampleSet, new Partition(partition, 2));
        result.selectSingleSubset(0);
        return new IOObject[]{result};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameterTypes = super.getParameterTypes();
        parameterTypes.add(new ParameterTypeInt("first_example", "The first example of the resulting example set.", 1, Integer.MAX_VALUE, false));
        parameterTypes.add(new ParameterTypeInt("last_example", "The last example of the resulting example set.", 1, Integer.MAX_VALUE, false));
        return parameterTypes;
    }
}

