/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.ConditionCreationException;
import edu.udo.cs.yale.example.ConditionExampleReader;
import edu.udo.cs.yale.example.ConditionedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleFilter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public ExampleFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet = this.getInput(ExampleSet.class);
        LogService.logMessage(String.valueOf(this.getName()) + ": input set has " + inputSet.size() + " examples.", 2);
        String className = this.getParameterAsString("condition_class");
        String parameter = this.getParameterAsString("parameter_string");
        this.logMessage("Creating condition '" + className + "' with parameter '" + parameter + "'", 2);
        Condition condition = null;
        try {
            condition = ConditionExampleReader.createCondition(className, inputSet, parameter);
        }
        catch (ConditionCreationException e) {
            throw new UserError((Operator)this, 904, className, (Object)e.getMessage());
        }
        ConditionedExampleSet result = new ConditionedExampleSet(inputSet, condition, this.getParameterAsBoolean("invert_filter"));
        return new IOObject[]{result};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory("condition_class", "Implementation of the condition.", ConditionExampleReader.KNOWN_CONDITION_NAMES, ConditionExampleReader.KNOWN_CONDITION_NAMES[0]);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString("parameter_string", "Parameter string for the condition, e.g. 'attribute=value' for the AttributeValueFilter.", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("invert_filter", "Indicates if only examples should be accepted which would normally filtered.", false));
        return types;
    }
}

