/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeAttributeType
extends Operator {
    private static final String REGULAR_NAME = "regular";
    private static final String[] TARGET_TYPES = new String[]{"regular", "id", "label", "prediction", "cluster", "weight", "batch"};

    public ChangeAttributeType(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        String name = this.getParameterAsString("name");
        Attribute attribute = exampleSet.getAttributes().get(name);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, name);
        }
        exampleSet.getAttributes().remove(attribute);
        String newType = this.getParameterAsString("target_type");
        if (newType == null || newType.trim().length() == 0) {
            throw new UserError((Operator)this, 201, new Object[]{"target_type", "change_attribute_type", "true"});
        }
        if (newType.equals(REGULAR_NAME)) {
            exampleSet.getAttributes().addRegular(attribute);
        } else {
            exampleSet.getAttributes().setSpecialAttribute(attribute, newType);
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString("name", "The name of the attribute of which the type should be changed.", false));
        types.add(new ParameterTypeStringCategory("target_type", "The target type of the attribute (only changed if parameter change_attribute_type is true).", TARGET_TYPES, TARGET_TYPES[0]));
        return types;
    }
}

