/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueMapper
extends Operator {
    public AttributeValueMapper(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet = this.getInput(ExampleSet.class);
        String attributeName = this.getParameterAsString("attribute_name");
        String replaceWhat = this.getParameterAsString("replace_what");
        String replaceBy = this.getParameterAsString("replace_by");
        Attribute attribute = inputSet.getAttributes().get(attributeName);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        if (attribute.isNominal()) {
            Tools.replaceValue(attribute, replaceWhat, replaceBy);
        } else {
            double oldValue = 0.0;
            try {
                oldValue = Double.parseDouble(replaceWhat);
            }
            catch (NumberFormatException e) {
                throw new UserError((Operator)this, 207, new Object[]{replaceWhat, "replace_what", "only numbers are allowed for numerical attributes"});
            }
            double newValue = 0.0;
            try {
                newValue = Double.parseDouble(replaceBy);
            }
            catch (NumberFormatException e) {
                throw new UserError((Operator)this, 207, new Object[]{replaceWhat, "replace_by", "only numbers are allowed for numerical attributes"});
            }
            Tools.replaceValue(inputSet, attribute, oldValue, newValue);
        }
        return new IOObject[]{inputSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString("attribute_name", "Mapping of values will be applied to this attribute.", false);
        types.add(type);
        type = new ParameterTypeString("replace_what", "All occurrences of this value will be replaced.", false);
        types.add(type);
        type = new ParameterTypeString("replace_by", "The new attribute value to use.", false);
        types.add(type);
        return types;
    }
}

