/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DoubleSparseArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.Ontology;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute2RealValueMapping
extends Operator {
    public Attribute2RealValueMapping(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = this.getInput(ExampleSet.class);
        ExampleSet result = null;
        LinkedList<String> nomAtts = new LinkedList<String>();
        if (this.getParameterAsBoolean("dichotomization")) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            if (this.getParameterAsBoolean("all_nominal_attributes")) {
                for (Attribute attribute : eSet.getAttributes()) {
                    if (attribute.isNominal()) {
                        this.handleNominalAttribute(attribute, attributes);
                        nomAtts.add(attribute.getName());
                        continue;
                    }
                    Attribute newAttribute = AttributeFactory.createAttribute(attribute.getName(), 4);
                    attributes.add(newAttribute);
                }
            } else {
                String nominal_attributes = this.getParameterAsString("nominal_attributes");
                if (nominal_attributes == null) {
                    nominal_attributes = "";
                }
                StringTokenizer st = new StringTokenizer(nominal_attributes, ",");
                while (st.hasMoreTokens()) {
                    nomAtts.add(st.nextToken());
                }
                for (Attribute attribute : eSet.getAttributes()) {
                    if (attribute.isNominal() && nomAtts.contains(attribute.getName())) {
                        this.handleNominalAttribute(attribute, attributes);
                        continue;
                    }
                    attributes.add(attribute);
                }
            }
            HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
            Iterator<AttributeRole> i = eSet.getAttributes().specialAttributes();
            while (i.hasNext()) {
                AttributeRole role = i.next();
                Attribute attribute = (Attribute)role.getAttribute().clone();
                attributes.add(attribute);
                specialMap.put(attribute, role.getSpecialName());
            }
            MemoryExampleTable exampleTable = new MemoryExampleTable(attributes);
            LinkedList<DataRow> dataRows = new LinkedList<DataRow>();
            for (Example example : eSet) {
                dataRows.add(this.createDataRow(example, eSet, specialMap, attributes.size(), attributes, nomAtts));
                this.checkForStop();
            }
            ListDataRowReader reader = new ListDataRowReader(dataRows.iterator());
            exampleTable.readExamples(reader);
            result = exampleTable.createExampleSet(specialMap);
        } else {
            if (this.getParameterAsBoolean("all_nominal_attributes")) {
                for (Attribute attribute : eSet.getAttributes()) {
                    eSet.getAttributes().replace(attribute, AttributeFactory.changeValueType(attribute, 4));
                }
            } else {
                String nominal_attributes = this.getParameterAsString("nominal_attributes");
                if (nominal_attributes == null) {
                    nominal_attributes = "";
                }
                StringTokenizer st = new StringTokenizer(nominal_attributes, ",");
                while (st.hasMoreTokens()) {
                    nomAtts.add(st.nextToken());
                }
                for (Attribute attribute : eSet.getAttributes()) {
                    if (attribute.isNominal() && nomAtts.contains(attribute.getName())) {
                        eSet.getAttributes().replace(attribute, AttributeFactory.changeValueType(attribute, 4));
                        continue;
                    }
                    if (attribute.isNominal()) continue;
                    eSet.getAttributes().replace(attribute, AttributeFactory.changeValueType(attribute, 4));
                }
            }
            result = eSet;
        }
        return new IOObject[]{result};
    }

    private void handleNominalAttribute(Attribute attribute, List<Attribute> attributes) {
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 8) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 8)) {
            Attribute newAttribute = AttributeFactory.createAttribute(attribute.getName(), 4);
            attributes.add(newAttribute);
        } else {
            Iterator<String> i = attribute.getMapping().getValues().iterator();
            while (i.hasNext()) {
                Attribute newAttribute = AttributeFactory.createAttribute(String.valueOf(attribute.getName()) + "_" + i.next(), 4);
                attributes.add(newAttribute);
            }
        }
    }

    private DataRow createDataRow(Example example, ExampleSet eSet, Map<Attribute, String> specialAttributes, int size, List allAttributes, List nomAtts) {
        Attribute newAttribute;
        DoubleSparseArrayDataRow result = new DoubleSparseArrayDataRow();
        int currentResultIndex = 0;
        for (Attribute oldAttribute : eSet.getAttributes()) {
            if (oldAttribute.isNominal() && nomAtts.contains(oldAttribute.getName())) {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 8) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 8)) {
                    newAttribute = (Attribute)allAttributes.get(currentResultIndex++);
                    result.set(newAttribute, example.getValue(oldAttribute));
                    continue;
                }
                int index = (int)example.getValue(oldAttribute);
                Attribute newAttribute2 = (Attribute)allAttributes.get(currentResultIndex + index);
                result.set(newAttribute2, 1.0);
                currentResultIndex += oldAttribute.getMapping().getValues().size();
                continue;
            }
            newAttribute = (Attribute)allAttributes.get(currentResultIndex++);
            result.set(newAttribute, example.getValue(oldAttribute));
        }
        for (Attribute oldAttribute : specialAttributes.keySet()) {
            newAttribute = (Attribute)allAttributes.get(currentResultIndex++);
            result.set(newAttribute, example.getValue(oldAttribute));
        }
        return result;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean("all_nominal_attributes", "If checked the values of all nominal attributes are mapped to numerical attributes.", true);
        types.add(type);
        type = new ParameterTypeString("nominal_attributes", "Comma-separated list of nominal attributes for mapping.");
        types.add(type);
        type = new ParameterTypeBoolean("dichotomization", "Uses one new attribute for each possible value of nominal attributes (new example table increasing used memory)", false);
        types.add(type);
        return types;
    }
}

