/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.filter;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.BinominalAttribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNominalValue
extends Operator {
    public AddNominalValue(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString("attribute_name"));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString("attribute_name"));
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 119, new Object[]{attribute.getName(), this.getName()});
        }
        if (attribute instanceof BinominalAttribute && attribute.getMapping().size() == 2) {
            Attribute newAttribute = AttributeFactory.changeValueType(attribute, 1);
            exampleSet.getAttributes().replace(attribute, newAttribute);
            attribute = newAttribute;
        }
        String newValue = this.getParameterAsString("new_value");
        attribute.getMapping().mapString(newValue);
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString("attribute_name", "The name of the nominal attribute to which values should be added.", false));
        types.add(new ParameterTypeString("new_value", "The value which should be added.", false));
        return types;
    }
}

