/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.discretization;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.operator.preprocessing.discretization.Discretization;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBinDiscretization
extends Discretization {
    public SimpleBinDiscretization(OperatorDescription description) {
        super(description);
    }

    @Override
    public double[][] getRanges(ExampleSet exampleSet) throws UndefinedParameterError {
        int numberOfBins = this.getParameterAsInt("number_of_bins");
        double[][] ranges = new double[exampleSet.getAttributes().size()][numberOfBins];
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) {
                NumericalAttributeStatistics stats = (NumericalAttributeStatistics)attribute.getStatistics();
                double min = stats.getMinimum();
                double max = stats.getMaximum();
                int b = 0;
                while (b < numberOfBins) {
                    ranges[a][b] = min + (double)(b + 1) / (double)numberOfBins * (max - min);
                    ++b;
                }
            }
            ++a;
        }
        return ranges;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_of_bins", "Defines the number of bins which should be used for each attribute.", 2, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

