/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.discretization;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.preprocessing.discretization.Discretization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalEntropyPartitioning
extends Discretization {
    public MinimalEntropyPartitioning(OperatorDescription description) {
        super(description);
    }

    private Double getMinEntropySplitpoint(LinkedList<double[]> truncatedExamples, Attribute label) {
        HashSet<Double> candidateSplitpoints = new HashSet<Double>();
        Iterator it = truncatedExamples.iterator();
        int[] totalLabelDistribution = new int[label.getMapping().size()];
        while (it.hasNext()) {
            int labelIndex;
            double[] attributeLabelPair = (double[])it.next();
            candidateSplitpoints.add(attributeLabelPair[0]);
            int n = labelIndex = (int)attributeLabelPair[1];
            totalLabelDistribution[n] = totalLabelDistribution[n] + 1;
        }
        double[] totalFrequencies = new double[label.getMapping().size()];
        int i = 0;
        while (i < label.getMapping().size()) {
            totalFrequencies[i] = (double)totalLabelDistribution[i] / (double)truncatedExamples.size();
            ++i;
        }
        double totalEntropy = 0.0;
        int i2 = 0;
        while (i2 < label.getMapping().size()) {
            totalEntropy -= totalFrequencies[i2] * this.log2(totalFrequencies[i2]);
            ++i2;
        }
        double minClassInformationEntropy = totalEntropy;
        double bestSplitpoint = Double.NaN;
        double bestSplitpointEntropy1 = Double.POSITIVE_INFINITY;
        double bestSplitpointEntropy2 = Double.POSITIVE_INFINITY;
        int k1 = 0;
        int k2 = 0;
        Iterator it1 = candidateSplitpoints.iterator();
        while (it1.hasNext()) {
            double currentSplitpoint = (Double)it1.next();
            int s1 = 0;
            int s2 = 0;
            k1 = 0;
            k2 = 0;
            int[] labelDistribution1 = new int[label.getMapping().size()];
            int[] labelDistribution2 = new int[label.getMapping().size()];
            for (double[] attributeLabelPair : truncatedExamples) {
                double valueToCompare = attributeLabelPair[0];
                int labelIndex = (int)attributeLabelPair[1];
                if (valueToCompare <= currentSplitpoint) {
                    ++s1;
                    int n = labelIndex;
                    labelDistribution1[n] = labelDistribution1[n] + 1;
                    continue;
                }
                ++s2;
                int n = labelIndex;
                labelDistribution2[n] = labelDistribution2[n] + 1;
            }
            double[] frequencies1 = new double[label.getMapping().size()];
            double[] frequencies2 = new double[label.getMapping().size()];
            int i3 = 0;
            while (i3 < label.getMapping().size()) {
                frequencies1[i3] = (double)labelDistribution1[i3] / (double)s1;
                frequencies2[i3] = (double)labelDistribution2[i3] / (double)s2;
                if (labelDistribution1[i3] > 0) {
                    ++k1;
                }
                if (labelDistribution2[i3] > 0) {
                    ++k2;
                }
                ++i3;
            }
            double entropy1 = 0.0;
            int i4 = 0;
            while (i4 < label.getMapping().size()) {
                entropy1 -= frequencies1[i4] * this.log2(frequencies1[i4]);
                ++i4;
            }
            double entropy2 = 0.0;
            int i5 = 0;
            while (i5 < label.getMapping().size()) {
                entropy2 -= frequencies2[i5] * this.log2(frequencies2[i5]);
                ++i5;
            }
            double classInformationEntropy = (double)s1 / (double)truncatedExamples.size() * entropy1 + (double)s2 / (double)truncatedExamples.size() * entropy2;
            if (!(classInformationEntropy < minClassInformationEntropy)) continue;
            minClassInformationEntropy = classInformationEntropy;
            bestSplitpoint = currentSplitpoint;
            bestSplitpointEntropy1 = entropy1;
            bestSplitpointEntropy2 = entropy2;
        }
        double gain = totalEntropy - minClassInformationEntropy;
        double delta = this.log2(Math.pow(3.0, label.getMapping().size()) - 2.0) - ((double)label.getMapping().size() * totalEntropy - (double)k1 * bestSplitpointEntropy1 - (double)k2 * bestSplitpointEntropy2);
        if (gain >= this.log2(truncatedExamples.size() - 1) / (double)truncatedExamples.size() + delta / (double)truncatedExamples.size()) {
            return new Double(bestSplitpoint);
        }
        return null;
    }

    private ArrayList getSplitpoints(LinkedList<double[]> startPartition, Attribute label) {
        LinkedList border = new LinkedList();
        ArrayList<Double> result = new ArrayList<Double>();
        border.addLast(startPartition);
        while (!border.isEmpty()) {
            LinkedList currentPartition = (LinkedList)border.removeFirst();
            Double splitpoint = this.getMinEntropySplitpoint(currentPartition, label);
            if (splitpoint == null) continue;
            result.add(splitpoint);
            double splitValue = splitpoint;
            LinkedList<double[]> newPartition1 = new LinkedList<double[]>();
            LinkedList<double[]> newPartition2 = new LinkedList<double[]>();
            for (double[] attributeLabelPair : currentPartition) {
                if (attributeLabelPair[0] <= splitValue) {
                    newPartition1.addLast(attributeLabelPair);
                    continue;
                }
                newPartition2.addLast(attributeLabelPair);
            }
            border.addLast(newPartition1);
            border.addLast(newPartition2);
        }
        return result;
    }

    @Override
    public double[][] getRanges(ExampleSet exampleSet) {
        double[][] ranges = new double[exampleSet.getAttributes().size()][];
        Attribute label = exampleSet.getAttributes().getLabel();
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) {
                Iterator reader = exampleSet.iterator();
                LinkedList<double[]> startPartition = new LinkedList<double[]>();
                while (reader.hasNext()) {
                    Example example = (Example)reader.next();
                    double[] attributeLabelPair = new double[]{example.getValue(attribute), example.getValue(label)};
                    startPartition.addLast(attributeLabelPair);
                }
                ArrayList splitpointsOfAttribute = this.getSplitpoints(startPartition, label);
                Iterator it = splitpointsOfAttribute.iterator();
                ranges[a] = new double[splitpointsOfAttribute.size() + 1];
                int i = 0;
                while (it.hasNext()) {
                    ranges[a][i] = (Double)it.next();
                    ++i;
                }
                ranges[a][ranges[a].length - 1] = ((NumericalAttributeStatistics)attribute.getStatistics()).getMaximum();
                Arrays.sort(ranges[a]);
            }
            ++a;
        }
        return ranges;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label == null || !label.isNominal()) {
            throw new UserError((Operator)this, 101, this.getName(), (Object)(label == null ? "no label" : label.getName()));
        }
        exampleSet.recalculateAllAttributeStatistics();
        this.checkForStop();
        double[][] ranges = this.getRanges(exampleSet);
        boolean[] numerical = new boolean[ranges.length];
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) {
                numerical[a] = true;
                attribute = exampleSet.getAttributes().replace(attribute, AttributeFactory.changeValueType(attribute, 1));
                int b = 0;
                while (b < ranges[a].length) {
                    attribute.getMapping().mapString("range" + (b + 1));
                    ++b;
                }
            } else {
                numerical[a] = false;
            }
            ++a;
        }
        for (Example example : exampleSet) {
            a = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (numerical[a] && ranges[a] != null) {
                    double value = example.getValue(attribute);
                    int b = 0;
                    while (b < ranges[a].length) {
                        if (value <= ranges[a][b]) {
                            example.setValue(attribute, attribute.getMapping().mapString("range" + (b + 1)));
                            break;
                        }
                        ++b;
                    }
                }
                ++a;
            }
            this.checkForStop();
        }
        a = 0;
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        while (i.hasNext()) {
            if (numerical[a] && ranges[a].length == 1) {
                i.remove();
            }
            ++a;
        }
        return new IOObject[]{exampleSet};
    }

    public double log2(double arg) {
        return Math.log(arg) / Math.log(2.0);
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }
}

