/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.discretization;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.preprocessing.discretization.FrequencyDiscretizerExample;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyDiscretizer
extends Operator {
    public FrequencyDiscretizer(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        boolean useSqrt = this.getParameterAsBoolean("use_sqrt_of_examples");
        int numberOfBins = 0;
        if (!useSqrt && (numberOfBins = this.getParameterAsInt("number_of_bins")) >= exampleSet.size() - 1) {
            throw new UserError((Operator)this, 116, "number_of_bins", (Object)("number of bins must be smaller than number of examples (here: " + exampleSet.size() + ")"));
        }
        Object[] exampleAttributePairs = new FrequencyDiscretizerExample[exampleSet.size()];
        for (Attribute currentAttribute : exampleSet.getAttributes()) {
            if (currentAttribute.isNominal()) continue;
            int numberOfNotMissing = 0;
            Iterator iterator = exampleSet.iterator();
            int j = 0;
            while (iterator.hasNext()) {
                Example currentExample = (Example)iterator.next();
                exampleAttributePairs[j] = new FrequencyDiscretizerExample(currentExample.getValue(currentAttribute), currentExample);
                if (!Double.isNaN(currentExample.getValue(currentAttribute))) {
                    ++numberOfNotMissing;
                }
                this.checkForStop();
                ++j;
            }
            Arrays.sort(exampleAttributePairs);
            if (useSqrt) {
                numberOfBins = (int)Math.round(Math.sqrt(numberOfNotMissing));
            }
            currentAttribute = exampleSet.getAttributes().replace(currentAttribute, AttributeFactory.changeValueType(currentAttribute, 1));
            double examplesPerBin = (double)exampleSet.size() / (double)numberOfBins;
            double currentBinSpace = 0.0;
            int currentBin = 0;
            LogService.logMessage(String.valueOf(this.getName()) + ": " + currentAttribute.getName() + ": start new range" + currentBin + " at " + Tools.formatNumber(((FrequencyDiscretizerExample)exampleAttributePairs[0]).getValue()), 2);
            int k = 0;
            while (k < exampleAttributePairs.length) {
                if (currentBinSpace < 1.0 && currentBin < numberOfBins) {
                    if (k > 0) {
                        double lastValue = ((FrequencyDiscretizerExample)exampleAttributePairs[k - 1]).getValue();
                        double thisValue = ((FrequencyDiscretizerExample)exampleAttributePairs[k]).getValue();
                        LogService.logMessage(String.valueOf(this.getName()) + ": " + currentAttribute.getName() + ": start new range" + currentBin + " at " + Tools.formatNumber((thisValue - lastValue) / 2.0), 2);
                    }
                    ++currentBin;
                    currentBinSpace += examplesPerBin;
                }
                Example example = ((FrequencyDiscretizerExample)exampleAttributePairs[k]).getExample();
                example.setValue(currentAttribute, "range" + currentBin);
                currentBinSpace -= 1.0;
                this.checkForStop();
                ++k;
            }
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt("number_of_bins", "Defines the number of bins which should be used for each attribute.", 2, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("use_sqrt_of_examples", "If true, the number of bins is instead determined by the square root of the number of non-missing values.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

