/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing.discretization;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;

public abstract class Discretization
extends Operator {
    public Discretization(OperatorDescription description) {
        super(description);
    }

    public abstract double[][] getRanges(ExampleSet var1) throws OperatorException;

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        exampleSet.recalculateAllAttributeStatistics();
        double[][] ranges = this.getRanges(exampleSet);
        boolean[] numerical = new boolean[ranges.length];
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) {
                numerical[a] = true;
                attribute = exampleSet.getAttributes().replace(attribute, AttributeFactory.changeValueType(attribute, 1));
                int b = 0;
                while (b < ranges[a].length) {
                    attribute.getMapping().mapString("range" + (b + 1));
                    ++b;
                }
            } else {
                numerical[a] = false;
            }
            ++a;
        }
        for (Example example : exampleSet) {
            a = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (numerical[a] && ranges[a] != null) {
                    double value = example.getValue(attribute);
                    int b = 0;
                    while (b < ranges[a].length) {
                        if (value <= ranges[a][b]) {
                            example.setValue(attribute, attribute.getMapping().mapString("range" + (b + 1)));
                            break;
                        }
                        ++b;
                    }
                }
                ++a;
            }
        }
        return new IOObject[]{exampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }
}

