/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Obfuscator
extends Operator {
    public Obfuscator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        HashMap<String, String> obfuscatorMap = new HashMap<String, String>();
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        Iterator<Attribute> i = exampleSet.getAttributes().allAttributes();
        while (i.hasNext()) {
            this.obfuscateAttribute(i.next(), obfuscatorMap, random);
        }
        File file = this.getParameterAsFile("obfuscation_map_file");
        if (file != null) {
            try {
                this.writeObfuscatorMap(obfuscatorMap, file);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 303, this.getParameterAsString("obfuscation_map_file"), (Object)e.getMessage());
            }
        }
        return new IOObject[]{exampleSet};
    }

    private void obfuscateAttribute(Attribute attribute, Map<String, String> obfuscatorMap, RandomGenerator random) {
        String oldName = attribute.getName();
        String newName = random.nextString(8);
        attribute.setName(newName);
        attribute.getConstruction().clear();
        obfuscatorMap.put(newName, oldName);
        if (attribute.isNominal()) {
            for (String oldValue : attribute.getMapping().getValues()) {
                String newValue = random.nextString(8);
                Tools.replaceValue(attribute, oldValue, newValue);
                obfuscatorMap.put(String.valueOf(oldName) + ":" + newValue, oldValue);
            }
        }
    }

    private void writeObfuscatorMap(Map<String, String> obfuscatorMap, File file) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        for (Map.Entry<String, String> e : obfuscatorMap.entrySet()) {
            out.println(String.valueOf(e.getKey()) + "\t" + e.getValue());
        }
        out.close();
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile("obfuscation_map_file", "File where the obfuscator map should be written to.", "obf", true);
        types.add(type);
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

