/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoiseOperator
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public NoiseOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        exampleSet.recalculateAllAttributeStatistics();
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        HashMap<String, Double> noiseMap = new HashMap<String, Double>();
        List noises = this.getParameterList("noise");
        for (Object[] pair : noises) {
            noiseMap.put((String)pair[0], (Double)pair[1]);
        }
        double defaultAttributeNoise = this.getParameterAsDouble("default_attribute_noise");
        double labelNoise = this.getParameterAsDouble("label_noise");
        Iterator reader = exampleSet.iterator();
        Attribute label = exampleSet.getAttributes().getLabel();
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (attribute.isNominal()) continue;
                Double noiseObject = (Double)noiseMap.get(attribute.getName());
                double noise = noiseObject == null ? defaultAttributeNoise : noiseObject;
                double noiseValue = random.nextGaussian() * noise;
                example.setValue(attribute, example.getValue(attribute) + noiseValue);
            }
            if (label != null) {
                if (!label.isNominal()) {
                    double labelRange = Math.abs(((NumericalAttributeStatistics)label.getStatistics()).getMaximum() - ((NumericalAttributeStatistics)label.getStatistics()).getMinimum());
                    double noiseValue = random.nextGaussian() * labelNoise * labelRange;
                    example.setValue(label, example.getValue(label) + noiseValue);
                } else if (label.isNominal() && label.getMapping().size() >= 2 && random.nextDouble() < labelNoise) {
                    int oldValue;
                    int newValue = oldValue = (int)example.getValue(label);
                    while (newValue == oldValue) {
                        newValue = random.nextInt(label.getMapping().size());
                    }
                    example.setValue(label, newValue);
                }
            }
            this.checkForStop();
        }
        int numberOfNewAttributes = this.getParameterAsInt("random_attributes");
        double offset = this.getParameterAsDouble("offset");
        double linearFactor = this.getParameterAsDouble("linear_factor");
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        int j = 0;
        while (j < numberOfNewAttributes) {
            Attribute newAttribute = AttributeFactory.createAttribute(AttributeFactory.createName("random"), 4);
            newAttributes.add(newAttribute);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
            ++j;
        }
        for (Example example : exampleSet) {
            Iterator i = newAttributes.iterator();
            while (i.hasNext()) {
                example.setValue((Attribute)i.next(), offset + linearFactor * random.nextGaussian());
            }
            this.checkForStop();
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("random_attributes", "Adds this number of random attributes.", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("label_noise", "Add this percentage of a numerical label range as a normal distributed noise or probability for a nominal label change.", 0.0, Double.POSITIVE_INFINITY, 0.05);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("default_attribute_noise", "The standard deviation of the default attribute noise.", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeList("noise", "List of noises for each attributes.", new ParameterTypeDouble("noise", "Names of attributes and noises to use.", 0.0, Double.POSITIVE_INFINITY, 0.05)));
        type = new ParameterTypeDouble("offset", "Offset added to the values of each random attribute", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        types.add(type);
        type = new ParameterTypeDouble("linear_factor", "Linear factor multiplicated with the values of each random attribute", 0.0, Double.POSITIVE_INFINITY, 1.0);
        types.add(type);
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

