/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdTagging
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public IdTagging(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        boolean nominalIds;
        ExampleSet eSet = this.getInput(ExampleSet.class);
        Attribute idAttribute = eSet.getAttributes().getId();
        if (idAttribute != null) {
            LogService.logMessage("Overwriting old id attribute!", 4);
        }
        idAttribute = Tools.createSpecialAttribute(eSet, "id", (nominalIds = this.getParameterAsBoolean("create_nominal_ids")) ? 1 : 3);
        int currentId = 1;
        for (Example example : eSet) {
            example.setValue(idAttribute, nominalIds ? idAttribute.getMapping().mapString("id_" + currentId) : currentId);
            ++currentId;
            this.checkForStop();
        }
        eSet.remapIds();
        return new IOObject[]{eSet};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean("create_nominal_ids", "True if nominal ids (instead of integer ids) should be created", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

