/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByOperator
extends Operator {
    public static final String ATTRIBUTE_NAME = "attribute_name";

    public GroupByOperator(OperatorDescription desc) {
        super(desc);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(ATTRIBUTE_NAME));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(ATTRIBUTE_NAME));
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 103, new Object[]{this.getParameterAsString(ATTRIBUTE_NAME), "grouping by attribute."});
        }
        SplittedExampleSet grouped = SplittedExampleSet.splitByAttribute(exampleSet, attribute);
        return new IOObject[]{grouped};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{SplittedExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(ATTRIBUTE_NAME, "Name of the attribute which is used to create partitions. If no such attribute is found in the input-exampleset or the attribute is not nominal or not an integer, execution will fail.", false));
        return types;
    }
}

