/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetMerge
extends Operator {
    public ExampleSetMerge(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        LinkedList<ExampleSet> allExampleSets = new LinkedList<ExampleSet>();
        boolean found = true;
        while (found) {
            try {
                ExampleSet exampleSet = this.getInput(ExampleSet.class);
                allExampleSets.add(exampleSet);
            }
            catch (MissingIOObjectException e) {
                found = false;
            }
        }
        if (allExampleSets.size() == 0) {
            throw new MissingIOObjectException(ExampleSet.class);
        }
        this.checkForCompatibility(allExampleSets);
        ExampleSet firstSet = (ExampleSet)allExampleSets.get(0);
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        HashMap<Attribute, String> specialAttributes = new HashMap<Attribute, String>();
        Iterator<AttributeRole> a = firstSet.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole role = a.next();
            Attribute attributeClone = (Attribute)role.getAttribute().clone();
            attributeList.add(attributeClone);
            if (!role.isSpecial()) continue;
            specialAttributes.put(attributeClone, role.getSpecialName());
        }
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributeList);
        Iterator i = allExampleSets.iterator();
        DataRowFactory factory = new DataRowFactory(this.getParameterAsInt("datamanagement"));
        while (i.hasNext()) {
            ExampleSet currentExampleSet = (ExampleSet)i.next();
            Iterator e = currentExampleSet.iterator();
            while (e.hasNext()) {
                DataRow dataRow = ((Example)e.next()).getDataRow();
                String[] newData = new String[attributeList.size()];
                Iterator<Attribute> oldAttributes = currentExampleSet.getAttributes().allAttributes();
                Iterator newAttributes = attributeList.iterator();
                int counter = 0;
                while (oldAttributes.hasNext() && newAttributes.hasNext()) {
                    Attribute oldAttribute = oldAttributes.next();
                    Attribute newAttribute = (Attribute)newAttributes.next();
                    double oldValue = dataRow.get(oldAttribute);
                    newData[counter] = newAttribute.isNominal() ? oldAttribute.getMapping().mapIndex((int)oldValue) : String.valueOf(oldValue);
                    ++counter;
                }
                exampleTable.addDataRow(factory.create(newData, exampleTable.getAttributes()));
                this.checkForStop();
            }
        }
        ExampleSet resultSet = exampleTable.createExampleSet(specialAttributes);
        return new IOObject[]{resultSet};
    }

    private void checkForCompatibility(List<ExampleSet> allExampleSets) throws OperatorException {
        ExampleSet first = allExampleSets.get(0);
        Iterator<ExampleSet> i = allExampleSets.iterator();
        while (i.hasNext()) {
            this.checkForCompatibility(first, i.next());
        }
    }

    private void checkForCompatibility(ExampleSet first, ExampleSet second) throws OperatorException {
        if (first.getAttributes().allSize() != second.getAttributes().allSize()) {
            throw new UserError((Operator)this, 925, "numbers of attributes are different");
        }
        Iterator<Attribute> firstIterator = first.getAttributes().allAttributes();
        Iterator<Attribute> secondIterator = second.getAttributes().allAttributes();
        while (firstIterator.hasNext()) {
            Attribute firstAttribute = firstIterator.next();
            Attribute secondAttribute = secondIterator.next();
            if (firstAttribute.getName().equals(secondAttribute.getName())) continue;
            throw new UserError((Operator)this, 925, "attribute names differ: " + firstAttribute.getName() + " vs. " + secondAttribute.getName());
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

