/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.preprocessing.AbstractExampleSetJoin;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetJoin
extends AbstractExampleSetJoin {
    public ExampleSetJoin(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MemoryExampleTable joinData(ExampleSet es1, ExampleSet es2, List<AbstractExampleSetJoin.AttributeSource> originalAttributeSources, List<Attribute> unionAttributeList) throws OperatorException {
        Attribute id1 = es1.getAttributes().getId();
        Attribute id2 = es2.getAttributes().getId();
        MemoryExampleTable unionTable = new MemoryExampleTable(unionAttributeList);
        for (Example example1 : es1) {
            double id1Value = example1.getValue(id1);
            Example example2 = null;
            example2 = id1.isNominal() ? es2.getExampleFromId(id2.getMapping().mapString(id1.getMapping().mapIndex((int)id1Value))) : es2.getExampleFromId(id1Value);
            if (example2 == null) {
                throw new UserError((Operator)this, 130, example1.getValueAsString(id1));
            }
            double[] unionDataRow = new double[unionAttributeList.size()];
            Iterator<AbstractExampleSetJoin.AttributeSource> a = originalAttributeSources.iterator();
            int index = 0;
            while (a.hasNext()) {
                AbstractExampleSetJoin.AttributeSource source = a.next();
                if (source.getSource() == 1) {
                    unionDataRow[index] = example1.getValue(source.getAttribute());
                } else if (source.getSource() == 2) {
                    unionDataRow[index] = example2.getValue(source.getAttribute());
                }
                ++index;
            }
            unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
            this.checkForStop();
        }
        return unionTable;
    }

    @Override
    protected boolean isIdNeeded() {
        return true;
    }
}

