/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.preprocessing.AbstractExampleSetJoin;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetCartesian
extends AbstractExampleSetJoin {
    public ExampleSetCartesian(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MemoryExampleTable joinData(ExampleSet es1, ExampleSet es2, List<AbstractExampleSetJoin.AttributeSource> originalAttributeSources, List<Attribute> unionAttributeList) throws OperatorException {
        MemoryExampleTable unionTable = new MemoryExampleTable(unionAttributeList);
        for (Example example1 : es1) {
            for (Example example2 : es2) {
                double[] unionDataRow = new double[unionAttributeList.size()];
                Iterator<AbstractExampleSetJoin.AttributeSource> a = originalAttributeSources.iterator();
                int index = 0;
                while (a.hasNext()) {
                    AbstractExampleSetJoin.AttributeSource source = a.next();
                    if (source.getSource() == 1) {
                        unionDataRow[index] = example1.getValue(source.getAttribute());
                    } else if (source.getSource() == 2) {
                        unionDataRow[index] = example2.getValue(source.getAttribute());
                    }
                    ++index;
                }
                unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                this.checkForStop();
            }
        }
        return unionTable;
    }

    @Override
    protected boolean isIdNeeded() {
        return false;
    }
}

