/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.tools.LogService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deobfuscator
extends Operator {
    public Deobfuscator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        File file = this.getParameterAsFile("obfuscation_map_file");
        Map<String, String> obfuscatorMap = null;
        try {
            obfuscatorMap = this.readObfuscatorMap(file);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, this.getParameterAsString("obfuscation_map_file"), (Object)e.getMessage());
        }
        Iterator<Attribute> i = exampleSet.getAttributes().allAttributes();
        while (i.hasNext()) {
            this.deObfuscateAttribute(i.next(), obfuscatorMap);
        }
        return new IOObject[]{exampleSet};
    }

    private void deObfuscateAttribute(Attribute attribute, Map<String, String> obfuscatorMap) {
        String obfuscatedName = attribute.getName();
        String newName = obfuscatorMap.get(obfuscatedName);
        if (newName != null) {
            attribute.setName(newName);
            attribute.getConstruction().clear();
        } else {
            LogService.logMessage("No name found in obfuscating map for attribute '" + obfuscatedName + "'.", 4);
        }
        if (attribute.isNominal()) {
            for (String obfuscatedValue : attribute.getMapping().getValues()) {
                String newValue = obfuscatorMap.get(String.valueOf(newName) + ":" + obfuscatedValue);
                if (newValue != null) {
                    Tools.replaceValue(attribute, obfuscatedValue, newValue);
                    continue;
                }
                LogService.logMessage("No value found in obfuscating map for value '" + obfuscatedValue + "' of attribute '" + attribute.getName() + "'.", 4);
            }
        }
    }

    private Map<String, String> readObfuscatorMap(File file) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = in.readLine()) != null) {
            String[] parts = line.trim().split("\\s");
            map.put(parts[0], parts[1]);
        }
        in.close();
        return map;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile("obfuscation_map_file", "File where the obfuscator map was written to.", "obf", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

