/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeSelectionExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NonSpecialAttributesExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeSubsetPreprocessing
extends OperatorChain {
    public AttributeSubsetPreprocessing(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet;
        ExampleSet workingExampleSet = inputSet = this.getInput(ExampleSet.class);
        if (this.getParameterAsBoolean("process_special_attributes")) {
            workingExampleSet = new NonSpecialAttributesExampleSet(inputSet);
        }
        if (this.isParameterSet("attribute_name_regex")) {
            workingExampleSet = this.createSubSetView(workingExampleSet);
            IOContainer input = new IOContainer(new IOObject[]{workingExampleSet});
            int i = 0;
            while (i < this.getNumberOfOperators()) {
                input = this.getOperator(i).apply(input);
                ++i;
            }
            if (this.getParameterAsBoolean("keep_subset_only")) {
                return new IOObject[]{this.createSubSetView(inputSet)};
            }
            return new IOObject[]{inputSet};
        }
        LogService.logMessage(String.valueOf(this.getName()) + ": regular expression for attribute names not set: not performing preprocessing at all!", 4);
        return new IOObject[]{inputSet};
    }

    private ExampleSet createSubSetView(ExampleSet exampleSet) throws UndefinedParameterError {
        boolean[] selectionMask = new boolean[exampleSet.getAttributes().size()];
        Pattern pattern = Pattern.compile(this.getParameterAsString("attribute_name_regex"));
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            Matcher matcher = pattern.matcher(attribute.getName());
            selectionMask[a] = matcher.matches();
            ++a;
        }
        return new AttributeSelectionExampleSet(exampleSet, selectionMask);
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{ExampleSet.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString("attribute_name_regex", "A regular expression which matches against all attribute names (including special attributes).");
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("process_special_attributes", "Indicates if special attributes like labels etc. should also be processed.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("keep_subset_only", "Indicates if the attributes which did not match the regular expression should be removed by this operator.", false));
        return types;
    }
}

