/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Ontology;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExampleSetJoin
extends Operator {
    public AbstractExampleSetJoin(OperatorDescription description) {
        super(description);
    }

    protected abstract MemoryExampleTable joinData(ExampleSet var1, ExampleSet var2, List<AttributeSource> var3, List<Attribute> var4) throws OperatorException;

    protected abstract boolean isIdNeeded();

    @Override
    public IOObject[] apply() throws OperatorException {
        AttributeRole role;
        ExampleSet es2 = this.getInput(ExampleSet.class);
        ExampleSet es1 = this.getInput(ExampleSet.class);
        if (this.isIdNeeded()) {
            Attribute id1 = es1.getAttributes().getId();
            Attribute id2 = es2.getAttributes().getId();
            if (id1 == null || id2 == null) {
                throw new UserError(this, 129);
            }
            if (id1.getValueType() != id2.getValueType()) {
                throw new UserError((Operator)this, 120, new Object[]{id2.getName(), Ontology.VALUE_TYPE_NAMES[id2.getValueType()], Ontology.VALUE_TYPE_NAMES[id1.getValueType()]});
            }
        }
        LinkedList<AttributeSource> originalAttributeSources = new LinkedList<AttributeSource>();
        LinkedList<Attribute> unionAttributeList = new LinkedList<Attribute>();
        for (Attribute attribute : es1.getAttributes()) {
            originalAttributeSources.add(new AttributeSource(1, attribute));
            unionAttributeList.add((Attribute)attribute.clone());
        }
        for (Attribute attribute : es2.getAttributes()) {
            Attribute cloneAttribute = (Attribute)attribute.clone();
            if (this.containsAttribute(unionAttributeList, attribute)) {
                if (this.getParameterAsBoolean("remove_double_attributes")) continue;
                originalAttributeSources.add(new AttributeSource(2, attribute));
                cloneAttribute.setName(String.valueOf(cloneAttribute.getName()) + "_from_ES2");
                if (this.containsAttribute(unionAttributeList, cloneAttribute)) {
                    cloneAttribute.setName(AttributeFactory.createName(String.valueOf(cloneAttribute.getName()) + "_from_ES2"));
                }
                unionAttributeList.add(cloneAttribute);
                continue;
            }
            originalAttributeSources.add(new AttributeSource(2, attribute));
            unionAttributeList.add(cloneAttribute);
        }
        HashMap<Attribute, String> unionSpecialAttributes = new HashMap<Attribute, String>();
        HashSet<String> usedSpecialAttributes = new HashSet<String>();
        Iterator<AttributeRole> s = es1.getAttributes().specialAttributes();
        while (s.hasNext()) {
            role = s.next();
            Attribute specialAttribute = role.getAttribute();
            Attribute specialAttributeClone = (Attribute)specialAttribute.clone();
            originalAttributeSources.add(new AttributeSource(1, specialAttribute));
            unionAttributeList.add(specialAttributeClone);
            unionSpecialAttributes.put(specialAttributeClone, role.getSpecialName());
            usedSpecialAttributes.add(role.getSpecialName());
        }
        s = es2.getAttributes().specialAttributes();
        while (s.hasNext()) {
            role = s.next();
            String specialName = role.getSpecialName();
            Attribute specialAttribute = role.getAttribute();
            if (!usedSpecialAttributes.contains(specialName)) {
                originalAttributeSources.add(new AttributeSource(2, specialAttribute));
                Attribute specialAttributeClone = (Attribute)specialAttribute.clone();
                unionAttributeList.add(specialAttributeClone);
                unionSpecialAttributes.put(specialAttributeClone, specialName);
                usedSpecialAttributes.add(specialName);
                continue;
            }
            LogService.logMessage("Special attribute '" + specialName + "' already exist, skipping!", 4);
        }
        MemoryExampleTable unionTable = this.joinData(es1, es2, originalAttributeSources, unionAttributeList);
        ExampleSet exampleSet = unionTable.createExampleSet(unionSpecialAttributes);
        return new IOObject[]{exampleSet};
    }

    public boolean containsAttribute(List<Attribute> attributeList, Attribute attribute) {
        Iterator<Attribute> i = attributeList.iterator();
        while (i.hasNext()) {
            if (!i.next().getName().equals(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("remove_double_attributes", "Indicates if double attributes should be removed or renamed", true));
        return types;
    }

    protected static class AttributeSource {
        protected static final int FIRST_SOURCE = 1;
        protected static final int SECOND_SOURCE = 2;
        protected int source;
        protected Attribute attribute;

        public AttributeSource(int source, Attribute attribute) {
            this.source = source;
            this.attribute = attribute;
        }

        protected int getSource() {
            return this.source;
        }

        protected Attribute getAttribute() {
            return this.attribute;
        }
    }
}

