/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.postprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.postprocessing.Threshold;
import edu.udo.cs.yale.tools.math.ROCDataGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdFinder
extends Operator {
    private static final String COSTS_NEG = "misclassification_costs_first";
    private static final String COSTS_POS = "misclassification_costs_second";
    private static final String SHOW_PLOT = "show_roc_plot";

    public ThresholdFinder(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute label = exampleSet.getAttributes().getLabel();
        exampleSet.recalculateAttributeStatistics(label);
        if (label == null) {
            throw new UserError(this, 105);
        }
        if (!label.isNominal()) {
            throw new UserError((Operator)this, 101, label, (Object)"threshold finding");
        }
        if (label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 118, new Object[]{label, label.getMapping().getValues().size(), 2});
        }
        ROCDataGenerator rocDataGenerator = new ROCDataGenerator(this.getParameterAsDouble(COSTS_POS), this.getParameterAsDouble(COSTS_NEG));
        List<double[]> rocData = rocDataGenerator.createROCDataList(exampleSet);
        if (this.getParameterAsBoolean(SHOW_PLOT)) {
            rocDataGenerator.createROCPlot(rocData, true, true);
        }
        return new IOObject[]{exampleSet, new Threshold(rocDataGenerator.getBestThreshold(), label.getMapping().getNegativeString(), label.getMapping().getPositiveString())};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Threshold.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        list.add(new ParameterTypeDouble(COSTS_NEG, "The costs assigned when an example of the first class is classified as one of the second.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        list.add(new ParameterTypeDouble(COSTS_POS, "The costs assigned when an example of the second class is classified as one of the first.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        list.add(new ParameterTypeBoolean(SHOW_PLOT, "Display a plot of the ROC curve.", false));
        return list;
    }
}

