/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.postprocessing;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.postprocessing.Threshold;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdCreator
extends Operator {
    public ThresholdCreator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        double threshold = this.getParameterAsDouble("threshold");
        String negativeClass = this.getParameterAsString("first_class");
        String positiveClass = this.getParameterAsString("second_class");
        return new IOObject[]{new Threshold(threshold, negativeClass, positiveClass)};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{Threshold.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("threshold", "The confidence threshold to determine if the prediction should be positive.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        list.add(type);
        list.add(new ParameterTypeString("first_class", "The class which should be considered as the first one (confidence 0).", false));
        list.add(new ParameterTypeString("second_class", "The class which should be considered as the second one (confidence 1).", false));
        return list;
    }
}

